<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

include_once PORTAL_APP_DIR . '/libraries/HTTP_Session/Session.php';

/**
 * Session class
 */
class Portal_Session {

    /**
     * Constructor
     * Avoid creation of instances.
     */
    private function __construct() {
        
    }

    /**
     * Destroy session
     */
    static function destroy($sessionid = false) {
        HTTP_Session::destroy($sessionid);
    }

    /**
     * Initialize session
     */
    static function init($sessionid = false) {
        if (empty($sessionid)) {
            HTTP_Session::start(null, null);
            $sessionid = HTTP_Session::id();
        } else {
            HTTP_Session::start(null, $sessionid);
        }

        if (HTTP_Session::isIdle() || HTTP_Session::isExpired()) {
            return false;
        }
        return $sessionid;
    }

    /**
     * Is key defined in session?
     */
    static function has($key) {
        return HTTP_Session::is_set($key);
    }

    /**
     * Get value for the key.
     */
    static function get($key, $defvalue = '') {
        return HTTP_Session::get($key, $defvalue);
    }

    /**
     * Set value for the key.
     */
    static function set($key, $value) {
        HTTP_Session::set($key, $value);
    }

}

class Portal_SessionHandler extends SessionHandler {
    
    /**
     * Overrided to make sure session read from memcache should not fail 
     * https://serverfault.com/questions/916129/php-7-2-failed-to-read-session-data-memcache
     * Read is always expected to return string. But, memcache will return null if any key doesn't 
     * exist. So, we are returning empty string if data is empty
     * @param type $session_id
     * @return string
     */
    public function read($session_id) {
        $sessiondata = parent::read($session_id);
        if(!$sessiondata) {
            $sessiondata = '';
        }
        
        return $sessiondata;
    }
    
}

$VTSessionHandler = new Portal_SessionHandler();
session_set_save_handler($VTSessionHandler);