<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_DownloadFile_API extends Portal_Default_API
{
    public function process(Portal_Request $request)
    {
        set_time_limit(0);
        ini_set('memory_limit','1024M');
        $module = $request->getModule();
        $parentId = $request->get('parentId');
		// Required attachment Id incase if module is modcomments
		// to support multiple attachment
		$attachmentId = $request->get('attachmentId');
        $parentModule = $request->get('parentModule');
        $result = Vtiger_Connector::getInstance()->downloadFile($module, $request->get('recordId', array()), $parentId, $parentModule,$attachmentId);
        $response = new Portal_Response();
        $resultArray = array();
        $resultArray['Content-Description'] = 'File Transfer';
        $resultArray['Content-Type'] = 'application/octet-stream';
        $resultArray['Content-Transfer-Encoding'] = 'binary';
        $resultArray['Content-type'] = $result['filetype'];
        $resultArray['Content-Length'] = $result['filesize'];
        $resultArray['filename'] = $result['filename'];
        $resultArray['filecontents'] = $result['filecontents'];
        $response->setResult($resultArray);
        return $response;
    }
}
