<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_FetchModules_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $result = Vtiger_Connector::getInstance()->fetchModules();
        $response = new Portal_Response();
        $response->setResult($this->processResponse($result));
        return $response;
    }

    public function processResponse($result) {
        $response = array();
        $info = $result['modules']['information'];
		$profileModules = $result['profileModules'];
		$profileModulesInfo = array();
        $modules = array();
        foreach ($info as $key => $value) {
            if (in_array($key, $profileModules)) {
				$profileModulesInfo[$key] = $value;
                unset($info[$key]);
            }
        }
        $response['moduleInfo'] = $info;
		$response['profileModulesInfo'] = $profileModulesInfo;
        if (isset($result['supportNotification']) && $result['supportNotification']['support_end_date']!==NULL) {
            $endDate = $result['supportNotification']['support_end_date'];
            $response['endDate'] = date('jS M, Y', strtotime($endDate));
        }
        $response['maxUploadFileSize'] = Portal_Config::get('upload_max_filesize');
        return $response;
    }

}
