<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

class Portal_FetchProfile_API extends Portal_FetchRecord_API {

    public function process(Portal_Request $request){
		$language = $request->getLanguage();
		// #3702553-Give option to update more fields in Customer portal profile.
		// Earlier, we supported limited fields of modules Contacts and Accounts in portal Profile.
		// Given configuration to select more fields for these modules in CRM. 
		$modules = $request->get('modules');
		$result = array();
		foreach($modules as $moduleName => $info) {
			$fieldName = ($moduleName == 'Contacts') ? 'contact_id' : 'parent_id';
			$recordId = Portal_Session::get($fieldName);
			if(!empty($recordId)) {
				// "FetchRecord" wil give result, contains configured fields 
				// in customer portal settings of respective module.
				$record = Vtiger_Connector::getInstance()->fetchRecord($recordId, '', $moduleName);
				$imageData = $record['record']['imagedata'];
				$imageType = $record['record']['imagetype'];
				unset($record['record']['imagedata']);
				unset($record['record']['imagetype']);
				$record = $this->processResponse($record, $moduleName, $language);
				// To show images for Profile modules.
				$record['imagedata'] = $imageData;
				$record['imagetype'] = $imageType;
				$record['module'] = $moduleName;
				if($moduleName == 'Contacts') {
					$result['customer_details'] = $record;
				} else {
					$result['company_details'] = $record;
				}
			}
		}
        $response = new Portal_Response();
		$response->setResult($this->filterResponse($result));

        return $response;
    }

	protected function filterResponse($result){
        $data = array();
        $data['customer_details'] = $result['customer_details'];
        $data['company_details'] = $result['company_details'];

        if (isset($data['company_details'])) {
            foreach ($data['company_details'] as $label => $value) {
                if ($label == 'website' && !empty($value)) {
                    $matchPattern = "^[\w]+:\/\/^";
                    preg_match($matchPattern, $value, $matches);
                    if (!empty($matches[0])) {
                        $value = $value;
                    } else {
                        $value = 'http://'.$value;
                    }
                    $data['company_details']['weburl'] = $value;
                }
            }
        }

        return $data;
    }
}
