<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

require_once 'include/utils/utils.php';

class Portal_FetchRecord_API extends Portal_Default_API {

    public function process(Portal_Request $request) {

        $module = $request->getModule();
        $language = $request->getLanguage();
		$selectedMode = $request->get('selectedMode');
        if (null !== ($request->get('parentId'))) {
            $parentId = $request->get('parentId');
            $result = Vtiger_Connector::getInstance()->fetchRecord($request->get('id'), $parentId, $module, $selectedMode);
        } else {
            $result = Vtiger_Connector::getInstance()->fetchRecord($request->get('id'), '', $module, $selectedMode);
        }

        $response = new Portal_Response();
        $response->setResult($this->processResponse($result, $module,$language));
        return $response;
    }

    public function processResponse($result, $module,$language) {
        $moduleMeta = array();
        $recordMeta = parent::processResponse($module,$language);
        $editFieldNames = array();
        $rteFields = array();
        if (!empty($result) && isset($result['record'])) {
            $requiredFields = array('isclosed', 'file_url');
            foreach ($result['record'] as $key => $value) {
                
                //record_currency_symbol is not a field, if we do not unset from record array then it will be treated 
                //as a new field and shows up in Portal Detail view. Hence moving it to module array.
                if($key == 'record_currency_symbol') {
                    $result[$module]['multiCurrencySymbol']=$value;
                    unset($result['record'][$key]);
                    continue;
                }
                
                if(in_array($key, $requiredFields)) {
                    continue;
                }
                
                $result['record']['identifierName'] = $recordMeta['labelField'];
                $name = $recordMeta[$key]['label'];
                $editFieldNames[$key] = $recordMeta[$key]['label'];
                if ($recordMeta[$key]['type'] == 'double' || $recordMeta[$key]['type'] == 'currency' || $recordMeta[$key]['type'] == 'multicurrency') {
                    $value = round($value, 2);
                }
                //Case record is saved with empty assigned_user_id when it is not assigned or accepted by any user.
                if($module=='Cases' && $key=='assigned_user_id' && $value==0){
                    $value = '';
                }
                //Case record is saved with empty group_id when it is not assigned to any group.
                if($module=='Cases' && $key=='group_id' && $value==0){
                    $value = '';
                }
                if ($recordMeta[$key]['type']=='picklist' || $recordMeta[$key]['type']=='metricpicklist' || $recordMeta[$key]['type']=='radio'){
                  foreach($recordMeta[$key]['picklistValues'] as $key1=>$value1){
                    if($module=='HelpDesk' && $key=='ticketstatus'){
                      $result['HelpDesk']['isStatusEditable'] = $recordMeta[$key]['editable'];
                        if($value1['value']=='Closed'){
                          $result['HelpDesk']['closeLabel']=$value1['label'];
                        }
                    }
                    
                    if($module=='Cases' && $key=='casestatus'){
                      $result['Cases']['isStatusEditable'] = $recordMeta[$key]['editable'];  
                        if($value1['value']=='Closed'){
                          $result['Cases']['closeLabel']=$value1['label'];
                        }
                        if($value1['value']=='Open'){
                          $result['Cases']['openLabel']=$value1['label'];
                        }
						if($value1['value']=='Resolved'){
                          $result['Cases']['resolveLabel']=$value1['label'];
                        }
                    }
                    
                    if($module=='Quotes' && $key=='quotestage'){
                        if($value1['value']=='Accepted'){
                          $result['Quotes']['acceptLabel']=$value1['label'];
                        }
                    }
                    if($result['record'][$key]==$value1['value']){

                      if($module=='HelpDesk' && $key=='ticketstatus' && $value=='Closed'){
                        $result['HelpDesk']['status']='Closed';
                      }
                      if($module=='HelpDesk' && $key=='ticketstatus' && $value!=='Closed'){
                        $result['HelpDesk']['status']='Open';
                      }
                      
                      if($module=='Cases' && $key=='casestatus' && $value=='Closed'){
                        $result['Cases']['status']='Closed';
                      }
                      if($module=='Cases' && $key=='casestatus' && $value!=='Closed'){
                        $result['Cases']['status']='Open';
                      }
					  if($module=='Cases' && $key=='casestatus' && $value=='Resolved'){
                        $result['Cases']['status']='Resolved';
                      }
                      
                      //Redmine - Bug #42639 - Case status not getting changed from Assigned to Open if reply done from portal.
                      if($module=='Cases' && $key=='casestatus'){
                          if(!in_array($value,array('New','Assigned','Open'))){
                              $result['Cases']['markopen']=true;
                          }else{
                              $result['Cases']['markopen']=false;
                          }
                      }
                      
                      if($module=='Quotes' && $key=='quotestage' && $value=='Accepted'){
                        $result['Quotes']['stage']='Accepted';
                      }
                      if($module=='Quotes' && $key=='quotestage' && $value!=='Accepted'){
                        $result['Quotes']['stage']='Created';
                      }
                      $value = $value1['label'];
                    }
                  }
                }
                if ($recordMeta[$key]['type'] == 'multipicklist') {
                    $value = str_replace(' |##| ', ",", $value);
                }
                if ($recordMeta[$key]['type'] == 'text') {
                  $value = strip_tags($value);
                  $value = preg_replace('/<br(\s+)?\/?>/i', "\n", $value);
                  if ($key == 'description' || $recordMeta[$key]['actual_field_type'] == 'richtext') {
                        $rteFields[$key] = $recordMeta[$key]['label'];
                  }
                }
                if ($recordMeta[$key]['type'] == 'boolean') {
                    $value = $value == 1 ? "Yes" : "No";
                }
                if ($recordMeta[$key]['type'] == 'integer' && $module=="Documents" && $key=='filesize') {
                    $value = round(($value/1024),2).'KB';
                }
                if ($recordMeta[$key]['type']=='string' && $key=='filelocationtype' && $module=='Documents'){
                  if ($value!=='' && $value=="I"){
                    $value="Internal";
                  }
                  if ($value!=='' && $value=="E"){
                    $value="External";
                  }
                }
                if ($recordMeta[$key]['type']=='file' && $key=='filename' && $module=='Documents'){
                  $docExists = true;
                  if ($value==''){
                    $docExists = false;
                  }
                }

                if ($recordMeta[$key]['type']=='reference'){
                  $result[$module]['referenceFields'][$name]=$value;
                }

                if ($recordMeta[$key]['type']=='string' || $recordMeta[$key]['type']=='string'){
                  $value = strip_tags($value);
                }

                if ($recordMeta[$key]['type']=='datetime' && $module=='Cases' && $key=='current_state_entry_time'){
                   $value = $this->convertElapsedTime($value,date('m/d/Y h:i:s a', time()));
                }
                
                if($recordMeta[$key]['type']=='datetime'){
                  $result[$module]['dateTimeFields'][] = $recordMeta[$key]['label'];
                }
				if($recordMeta[$key]['type'] == 'date' || $recordMeta[$key]['type'] == 'anniversary') {
                  $result[$module]['dateFields'][] = $recordMeta[$key]['label'];
                }

                // Set language value as portal language lable. 
                if($module == 'Contacts' && $key == 'language' && $recordMeta[$key]['type'] == 'picklist') {
                    $availableLanguages =  Portal_Config::get('languages');
                    foreach ($availableLanguages as $languageArray) {
                        if($value == $languageArray['value']) {
                            $value = $languageArray['label'];
                            break;
                        }
                    }
                }
                
                if ($recordMeta[$key]['type'] == 'estimate'){
                    $value = humanizeEstimate($value);
                }
                
                if ($key !== 'id') {
                    /**
                     * These two values are added to identify record approval status. As these are not fields to 
                     * show in the view we should unset these values after getting the values
                     */
                    if(in_array($key, array('isWaitingForApproval', 'isLocked'))) {
                        $result[$key] = $value;
                    } else {
                        $result['record'][$name] = $value;
                    }
					if($module== "Documents"){
						if($key !=="filename" && $key != 'filetype'){
							unset($result['record'][$key]);
						}
					} else {
						unset($result['record'][$key]);
					}
				}
                if (is_array($value)) {
                    $result['record'][$name] = $value['label'];
                    unset($result['record'][$key]);
                }
                if ($docExists && $module=='Documents'){
                  $result['record']['documentExists']=true;
                }
            }
            $result['editLabels']=$editFieldNames;
            $result['rteFields']=$rteFields;
        }
        return $result;
    }
    
    public function convertElapsedTime($value,$currentDate){
         $minutes = (strtotime($currentDate) - strtotime($value)) / 60;
        $timeString = '';
        if ($minutes != 'NULL' && $value !== '0000-00-00 00:00:00') {
            $minutes = $minutes * 60;
            $s = (floor($minutes % 60) > 0) ? ($minutes % 60) . ' seconds ' : '';
            $m = (floor(($minutes % 3600) / 60) > 0) ? floor(($minutes % 3600) / 60) . ' minutes' : '';
            $h = (floor(($minutes % 86400) / 3600) > 0) ? floor(($minutes % 86400) / 3600) . ' hours' : '';
            $d = (floor(($minutes % 2592000) / 86400) > 0) ? floor(($minutes % 2592000) / 86400) . ' days' : '';
            $Mo = (floor($minutes / 2592000) > 0) ? floor($minutes / 2592000) . ' months' : '';
            $timeString = "$Mo $d $h $m $s";
        }
        return $timeString;
    }

}
