<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

require_once 'include/utils/utils.php';

class Portal_FetchRecords_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $module = $request->getModule();
        $language  = Portal_Session::get('language');
        $params = $request->get('q');
        $pageNo = $params['page'];
        $filter = $request->get('filter');
        if (empty($pageNo))
            $pageNo = 0;
        $pageLimit = $params['pageLimit'];
        if (empty($pageLimit))
            $pageLimit = 10;
        if (!empty($filter)) {
            $params['fields'] = json_encode($filter);
        }
        $order = $params['order'];
        $orderBy = $params['orderBy'];
        $result = Vtiger_Connector::getInstance()->fetchRecords($module, $request->get('label'), $request->get('q', array()), $params['fields'], $pageNo, $pageLimit);
        $response = new Portal_Response();
        $response->setResult($this->processResponse($result, $module,$language));
        return $response;
    }

    public function processResponse($result, $module,$language,$isExport=false) {
      if($result['records']===null){
        return $result;
      }
        $headers = $result['headers'];
        $records = $result['records'];
        $edits = $result['edit'];
        unset($result['edit']);
        $recordMeta = parent::processResponse($module,$language);
        if($isExport){
          $recordMeta['Timezone'] =  array('type'=>'string','label'=>'Timezone');
        }
        $headerNames = array();
        $editFieldNames = array();
        $dateTimeFields = array();
		$dateFields = array();
        foreach ($headers as $key) {
            if($recordMeta[$key]) {
                array_push($headerNames, $recordMeta[$key]['label']);
            }
        }
        foreach ($edits as $key){
          $editFieldNames[$recordMeta[$key]['label']] = $key;
        }
        $requiredFields = array('isclosed', 'file_url');
        foreach ($records as $key => $value) {
            foreach ($value as $fieldLabel => $fieldValue) {
                if(in_array($fieldLabel, $requiredFields)) {
                    continue;
                }
                if ($recordMeta[$fieldLabel]['type']=='picklist' || $recordMeta[$fieldLabel]['type']=='metricpicklist' || $recordMeta[$fieldLabel]['type']=='radio'){

                foreach($recordMeta[$fieldLabel]['picklistValues'] as $key1=>$value1){
                  if($value[$fieldLabel]==$value1['value']){

                    $fieldValue = $value1['label'];
                  }
                }
              }
                if ($recordMeta[$fieldLabel]['type'] == 'multipicklist') {
                    $fieldValue = str_replace(' |##| ', ",", $fieldValue);
                }
                if ($recordMeta[$fieldLabel]['type'] == 'double' || $recordMeta[$fieldLabel]['type'] == 'currency' || $recordMeta[$fieldLabel]['type'] == 'multicurrency') {
                    $fieldValue = round($fieldValue, 2);
                }
                if ($recordMeta[$fieldLabel]['type'] == 'boolean') {
                    $fieldValue = $fieldValue == 1 ? "Yes" : "No";
                }
                if ($recordMeta[$fieldLabel]['type'] == 'integer' && $module=='Documents' && $fieldLabel=='filesize') {

                    $fieldValue = round(($fieldValue/1024),2).'KB';
                }
                if ($recordMeta[$fieldLabel]['type']=='string' && $fieldLabel=='filelocationtype' && $module=='Documents'){
                  if ($fieldValue!=='' && $fieldValue=="I"){
                    $fieldValue="Internal";
                  }
                  if ($fieldValue!=='' && $fieldValue=="E"){
                    $fieldValue="External";
                  }
                }
                if ($recordMeta[$fieldLabel]['type']=="text"){
                  $fieldValue = strip_tags($fieldValue);
                  $fieldValue = preg_replace('/<br(\s+)?\/?>/i', "\n", $fieldValue);
                }
                if ($recordMeta[$fieldLabel]['type']=="file" && $fieldLabel=='filename' && $module=='Documents'){
                  $docExists = true;
                  if ($fieldValue==''){
                    $docExists = false;
                  }

                }
                
                if ($recordMeta[$fieldLabel]['type']=='datetime' && $module=='Cases' && $fieldLabel=='current_state_entry_time'){
                   $fieldValue = $this->convertElapsedTime($fieldValue,date('m/d/Y h:i:s a', time()));
                }
                //Case record is saved with empty assigned_user_id when it is not assigned or accepted by any user.
                if($module == 'Cases' && $recordMeta[$fieldLabel]['type'] == 'owner' && $fieldLabel=='assigned_user_id'){
                    if($fieldValue=='0'){
                        $fieldValue = '';
                    }
                }
                 //Case record is saved with empty group_id when it is not assigned to any group.
                if($module == 'Cases' && $recordMeta[$fieldLabel]['type'] == 'ownergroup' && $fieldLabel == 'group_id'){
                    if($fieldValue=='0'){
                        $fieldValue = '';
                    }
                }
                
                if ($recordMeta[$fieldLabel]['type'] == 'estimate'){
                    $fieldValue = humanizeEstimate($fieldValue);
                }
                
                if ($recordMeta[$fieldLabel]['type']=='datetime'){
                   $dateTimeFields[] = $recordMeta[$fieldLabel]['label'];
                }
				if($recordMeta[$fieldLabel]['type'] == 'date' || $recordMeta[$fieldLabel]['type'] == 'anniversary') {
                   $dateFields[] = $recordMeta[$fieldLabel]['label'];
                }
                if ($fieldLabel !== 'id') {
                    $fieldValue = strip_tags($fieldValue);
                    $value[$recordMeta[$fieldLabel]['label']] = $fieldValue;
					if($module == 'Documents' ){
						if($fieldLabel!=="filename" && $fieldLabel!=="filetype"){
							unset($value[$fieldLabel]);
						}
					} else {
						unset($value[$fieldLabel]);
					}
				}
                if ($isExport){
                  unset ($value['id']);
                  $value['Timezone'] = $fieldValue;
                }
            }
            $records[$key] = $value;
            if(($docExists && $module=='Documents') || $module=='Invoice' || $module=='Quotes'){
              $records[$key]['documentExists'] = true;
            }
        }
        $result['headers'] = $headerNames;
        $result['records'] = $records;
        $result['editLabels']=$editFieldNames;
        $result['dateTimeFields'] = array_unique($dateTimeFields);
		$result['dateFields'] = array_unique($dateFields);
        $result['pageLimit'] = 10;
        return $result;
    }
    
        public function convertElapsedTime($value,$currentDate){
         $minutes = (strtotime($currentDate) - strtotime($value)) / 60;
        $timeString = '';
        if ($minutes != 'NULL' && $value !== '0000-00-00 00:00:00') {
            $minutes = $minutes * 60;
            $s = (floor($minutes % 60) > 0) ? ($minutes % 60) . ' seconds ' : '';
            $m = (floor(($minutes % 3600) / 60) > 0) ? floor(($minutes % 3600) / 60) . ' minutes' : '';
            $h = (floor(($minutes % 86400) / 3600) > 0) ? floor(($minutes % 86400) / 3600) . ' hours' : '';
            $d = (floor(($minutes % 2592000) / 86400) > 0) ? floor(($minutes % 2592000) / 86400) . ' days' : '';
            $Mo = (floor($minutes / 2592000) > 0) ? floor($minutes / 2592000) . ' months' : '';
            $timeString = "$Mo $d $h $m $s";
        }
        return $timeString;
    }

}
