<?php

/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/

require_once 'include/utils/utils.php';

class Portal_FetchRelatedRecords_API extends Portal_Default_API {

    public function process(Portal_Request $request) {
        $pageNo = $request->get('page');
        $module = $request->get('module');
        $language = Portal_Session::get('language');
        if (empty($pageNo)) {
            $pageNo = 1;
        }
        $pageLimit = $request->get('pageLimit');
        if (empty($pageLimit)) {
            $pageLimit = 10;
        }
        $result = Vtiger_Connector::getInstance()->fetchRelatedRecords($request->get('relatedModule'), $request->get('relatedModuleLabel'), $request->get('id'), $request->get('parentId'), $pageNo, $pageLimit, $module, $request->get('filter', array()), $request->get('roll_up_to', false));
        $response = new Portal_Response();
        $response->setResult($this->processResponse($result, $request->get('relatedModule'), $language));

        return $response;
    }

    public function processResponse($result, $relatedModule,$language) {
        $response = array();
        if ($relatedModule == 'ModComments') {
            $response['comments'] = $result;
            $response['more'] = $result['more'];
            return $response;
        }
        $recordMeta = parent::processResponse($relatedModule, $language);
        $headers = $records = $dateTimeFields = array();
		$dateFields = array();
        $more = $result['more'];
        unset($result['more']);
        $requiredFields = array('isclosed', 'file_url', 'parentId');
        for ($i = 0; $i < count($result); $i++) {
            if ($result[$i]) {
                $record = array();
                foreach ($result[$i] as $field => $value) {
                    
                    //record_currency_symbol is not a field, if we do not unset from record array then it will be treated 
                    //as a new field and shows up in Related record list view. Hence unsetting from the record array.
                    if($field == 'record_currency_symbol') {
                        unset($result[$i][$field]);
                        continue;
                    }
                    
                    if(in_array($field, $requiredFields)) {
                        $record[$field] = $value;
                        continue;
                    }
                    
                    if ($i == 0 && $recordMeta[$field]['label']) {
                        $headers[] = $recordMeta[$field]['label'];
                    }
                    if (is_array($value)) {
                        $record[$recordMeta[$field]['label']] = $value['label'];
                    } else {
                        if ($recordMeta[$field]['type']=='picklist' || $recordMeta[$field]['type']=='metricpicklist' || $recordMeta[$field]['type']=='radio'){
                            foreach($recordMeta[$field]['picklistValues'] as $key1=>$value1){
                                if($value == $value1['value']){
                                    $value = $value1['label'];
                                }
                            }
                        }
                        if ($recordMeta[$field]['type'] == 'double' || $recordMeta[$field]['type'] == 'currency' || $recordMeta[$field]['type'] == 'multicurrency') {
                            $value = round($value, 2);
                        }
                        if ($recordMeta[$field]['type'] == 'estimate') {
                            $value = humanizeEstimate($value);
                        }
                        if ($recordMeta[$field]['type'] == 'multipicklist') {
                          $value = str_replace(' |##| ', ",", $value);
                        }
                        if ($recordMeta[$field]['type'] == 'boolean') {
                          $value = $value == 1 ? "Yes" : "No";
                        }
                        if ($recordMeta[$field]['type'] == 'text') {
                            $value = strip_tags($value);
                            $value = preg_replace('/<br(\s+)?\/?>/i', "\n", $value);
                        }
                        if ($field == 'filelocationtype' && $relatedModule == 'Documents') {
                        if ($value!=='' && $value=="I"){
                          $value="Internal";
                            }
                        if ($value!=='' && $value=="E"){
                          $value="External";
                            }
                        }
                        if ($recordMeta[$field]['type'] == 'multipicklist') {
                             $value = str_replace(' |##| ', ',', $value);
                            }
                        if ($recordMeta[$field]['type']=='datetime'){
                              $dateTimeFields[] = $recordMeta[$field]['label'];
                            }
						if($recordMeta[$field]['type'] == 'date' || $recordMeta[$field]['type'] == 'anniversary') {
							$dateFields[] = $recordMeta[$field]['label'];
						}
                      if ($recordMeta[$field]['type']=="file" && $field=='filename' && $relatedModule=='Documents'){
                            $docExists = true;
                            if ($value == '') {
                                $docExists = false;
                            }
                        }
                        if ($field == 'filesize' && $recordMeta[$field]['type'] == 'integer' && $relatedModule == 'Documents') {
                            $value = round(($value / 1024), 2) . 'KB';
                        }
                        $record[$recordMeta[$field]['label']] = $value;
                        if($relatedModule === 'Documents'){
	                        if($field === 'filename' || $field ===  'filetype'){
	                            $record[$field] = $value;
	                        }
                        }
                    }
                }
            }
            if ($docExists) {
                $record['documentExists'] = true;
            }
            $records[] = $record;
        }
        $dateTimeFields = array_unique($dateTimeFields);
        return array('headers' => $headers, 'records' => $records,'dateTimeFields'=>$dateTimeFields, 'dateFields' => array_unique($dateFields), 'more'=>$more);
    }

}
