<?php
/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
class Portal_Main_Controller {

    protected function initLogin($redirectUri) {
        if (!Vtiger_Connector::getInstance()->isAuthenticated()) {
            //Store the URL when login fails to redirect to same URL after login.
            echo '<script>localStorage.setItem("__p_redirect_to", window.location.href);</script>';
            if ($redirectUri) {
                //Using header doesn't let script tags to store the URL in local storage
                echo'<script>window.location="index.php?'.$redirectUri.'"</script>';
                exit;
            } else {
                throw new Exception('Authentication required');
            }
        }
    }

    public function dispatch(Portal_Request $request) {
        Portal_Session::init();

        $response = null;
        try {
            $module = $request->getModule('Portal');
            $view = $request->getView('Index');
            $api = $request->getApi();

            // Routing
            // module=Target&view=Index (try: Target_Index_View, Portal_Default_View - a generic handler)
            // module=Target&api=Context  (try: Target_Context_API,  Portal_Context_API - a fallback handler)

            $targetClass = $module . "_" . ($api ? $api : $view) . "_" . ($api ? "API" : "View");
            $fallbackClass = "Portal_" . ($api ? $api : 'Default') . "_" . ($api ? "API" : "View");
            $target = class_exists($targetClass) ? new $targetClass() : new $fallbackClass();
            if (!$target) {
                throw new Exception('Unsupported request');
            }

            if ($target->requireLogin()) {
                $this->initLogin($api ? NULL : "module=Portal&view=Login");
            }

            if (!$api && !$request->isAjax())
                $target->preProcess($request);

            $response = $target->process($request);

            if (!$api && !$request->isAjax())
                $target->postProcess($request);
        } catch (Exception $e) {
            $response = new Portal_Response();

            $response->setError($e->getMessage());
        }

        if ($response) {
            $response->emit();
        }
    }

}
