<?php
/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
include_once 'version.php';

if(file_exists('config.inc.php')){
  	//Take in the configured URL as $site_URL from Portal.
    	include_once 'config.inc.php';
}
if(file_exists('../config.inc.php')){
  	//Take in the default $site_URL from CRM
	include_once '../config.inc.php';
}
version_compare(PHP_VERSION, '5.5.0') <= 0 ? error_reporting(E_WARNING & ~E_NOTICE & ~E_DEPRECATED) : error_reporting(E_WARNING & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT); // PRODUCTION
//ini_set('display_errors','on'); version_compare(PHP_VERSION, '5.5.0') <= 0 ? error_reporting(E_WARNING & ~E_NOTICE & ~E_DEPRECATED) : error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);   // DEBUGGING

class Portal_Config_Data {

    protected static $data = array(
        'crm.url' => '/modules/CustomerPortal/api.php',
        'crm.version' => '6.15.1', // Framework version for API
        'language' => 'en_us',// Default Language for API . Note : Changing the language here will not change the default/login language for Portal user.
        'layout' => 'default',
    );

    protected static function getData() {
        global $site_URL;
        global $companyName;
        global $logoPath;
        global $portalCurrentVersion;
        global $maxFileSize;
        global $defaultUiLanguage;
        global $availableLanguages;
        $crmUrl = self::$data['crm.url'];
        if (!empty($site_URL) && strpos($crmUrl, $site_URL) === false){
            self::$data['crm.url'] = $site_URL . $crmUrl;
          }  
        self::$data['org.name']=$companyName;
        self::$data['logo.path']=$logoPath;
        self::$data['portal.version']=$portalCurrentVersion;
        self::$data['upload_max_filesize']=$maxFileSize;
        self::$data['ui.Language']=$defaultUiLanguage;
        self::$data['languages']=$availableLanguages;
        return self::$data;
    }

}
