/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
portalapp.controller("Calendar_DetailView_Component",function($scope, $api, $webapp, $translatePartialLoader, sharedModalService, $modal,$controller) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    $controller("Portal_DetailView_Component",({$scope:$scope}));
    // To enable add comments for Tasks. 
    $scope.isCommentCreateable = true;
    
    // To upload Documents for Tasks.
    $scope.$on('editRecordModalDocuments.Template', function () {
        $modal.open({
            templateUrl: 'editRecordModalDocuments.template',
            controller: 'Documents_EditView_Component',
            backdrop: 'static',
            keyboard: 'false',
            resolve: {
                record: function () {
                    return {'parentId': $scope.id, 'parentModule': $scope.module};
                },
                api: function () {
                    return $api;
                },
                webapp: function () {
                    return $webapp;
                },
                module: function () {
                    return 'Documents';
                }
            }
        });
    });

    $scope.attachDocument = function (module, action) {
        var actionConfig = {'LBL_ADD_DOCUMENT': 'Documents'};
        if (actionConfig.hasOwnProperty(action)) {
            sharedModalService.prepForModal(actionConfig[action]);
        }
    }
});

portalapp.controller("Calendar_IndexView_Component",function($scope, $api, $webapp,$translatePartialLoader,$controller) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    $controller("Portal_IndexView_Component",({$scope:$scope}));
    // To enable filters for Tasks. 
    $scope.isFilterEnabled = true;
});
