/*
 *Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
*/
portalapp.controller("Documents_IndexView_Component",function( $scope, $api, $webapp, $modal, $translatePartialLoader,$controller) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
	/*@ngInject*/
	if ( $translatePartialLoader !== undefined ) {
		$translatePartialLoader.addPart( 'home' );
		$translatePartialLoader.addPart( 'Documents' );
	}
    
	var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
	var currentModule ='Documents';
    
    $scope.$root.$on('LoginUser.Ready', function () {
        // Re-initialize all modules if not available
        if (!availableModules) availableModules = $scope.modules;
        //set creatable true
        if (availableModules !== null && availableModules[currentModule]) {
            $scope.isCreatable = availableModules[ currentModule ].create;
            $scope.filterPermissions = availableModules[currentModule].recordvisibility;
            $scope.isPreviewAllowed = availableModules[ currentModule ].preview;
            $scope.isDownloadAllowed = availableModules[ currentModule ].download;
        }
    });

	$controller("Portal_IndexView_Component",({$scope:$scope}));

	$scope.$on( 'editRecordModalDocuments.Template', function () {
		$modal.open( {
			templateUrl: 'editRecordModalDocuments.template',
			controller: 'Documents_EditView_Component',
			backdrop: 'static',
			keyboard: 'false',
			resolve: {
				record: function () {
					return {};
				},
				api: function () {
					return $api;
				},
				webapp: function () {
					return $webapp;
				},
				module: function () {
					return 'Documents';
				}
			}
		} );
	} );

	$scope.isCreateable = true;
	$scope.viewLoading = true;
    $scope.isPreviewAllowed = true;
    $scope.isDownloadAllowed = true;
    
	$scope.$watch( 'searchQ.folder', function ( nvalue, ovalue ) {
		if ( nvalue != ovalue ) {
			$scope.loadRecords();
		}
	} );

	$scope.create = function () {
		var modalInstance = $modal.open( {
			templateUrl: 'editRecordModalDocuments.template',
			controller: 'Documents_EditView_Component',
			backdrop: 'static',
			keyboard: 'false',
			resolve: {
				record: function () {
					return {};
				},
				api: function () {
					return $api;
				},
				webapp: function () {
					return $webapp;
				},
				module: function () {
					return $scope.module;
				},
			}
		} );
	}

	$scope.checkRecordsVisibility = function(filterValue){
		var returnValue;
		switch (filterValue) {
			case "1":
				returnValue = true;
				break;
			case "0":
				returnValue = false;
				break;
			case "2":
				returnValue = false;
				break;
			default:
				returnValue = false;
		}
		return returnValue;
	}

});

portalapp.controller("Documents_DetailView_Component",function($scope,$controller) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
    var availableModules = JSON.parse( localStorage.getItem( 'modules' ) );
    
    $controller("Portal_DetailView_Component",({$scope:$scope}));
    
    $scope.isPreviewAllowed = availableModules[ $scope.module ].preview;
    $scope.isDownloadAllowed = availableModules[ $scope.module ].download;
    $scope.isCommentCreateable = true;
});

portalapp.controller("Documents_EditView_Component",function( $scope, $modalInstance, record, api, webapp, module, $http, $translatePartialLoader, ngProgress ) {
	$scope.dateFormat = getDateFormat();
	$scope.timeFormat = getTimeFormat();
	/*@ngInject*/
	$scope.editRecord = angular.copy( record );
	$scope.structure = null;
	if ( $translatePartialLoader !== undefined ) {
		$translatePartialLoader.addPart( 'Documents' );
	}
	$scope.maxUploadFileSize = localStorage.getItem('maxUploadFileSize');
	$scope.save = function () {
		var fd = new FormData();
		if ( $scope.editRecord.folderid !== undefined ) {
			fd.append( 'folderid', $scope.editRecord.folderid );
		}
		fd.append( 'module', 'Documents' );
		fd.append( 'api', 'UploadAttachment' );
		if ( record.parentId !== undefined && record.parentModule !== undefined )
			fd.append( 'parentId', record.parentId );
		if ( $scope.editRecord !== undefined ) {
			fd.append( 'file', $scope.editRecord.filename[ 0 ] );
			ngProgress.start();
			$scope.saving = true;
			$http.post( 'index.php?', fd, {
					transformRequest: angular.identity,
					headers: {
						'Content-Type': undefined
					}
				} )
				.success( function ( data ) {
					if ( data.success ) {
						$modalInstance.close( $scope.editRecord.filename[ 0 ] );
						ngProgress.complete();
						if ( record.parentId === undefined ) {
							window.location.href = 'index.php?module=' + module + '&view=Detail&id=' + data.result.record.id;
						} else if ( record.parentId !== undefined && record.parentModule !== undefined ) {
							window.location.href = 'index.php?module=' + record.parentModule + '&view=Detail&id=' + record.parentId;
						}
					} else {
						$modalInstance.dismiss( 'cancel' );
						alert( data.error[ 'message' ] );
					}
				} );
		}
	};

	$scope.cancel = function () {
		$modalInstance.dismiss( 'cancel' );
	}
});
