{*<!--
  /*
   *Copyright (C) www.vtiger.com. All rights reserved.
   * @license Proprietary
  */
-->*}

{literal}
    <div class="row" ng-if="isCommentCreateable">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <form ng-submit="addComment(commentForm.$valid)" name="commentForm" novalidate="novalidate">
                <textarea msd-elastic style="resize:none;" name="comment" ng-model="newcomment.commentcontent" class="form-control text-left" placeholder="{{'Add your comment here'|translate}}..." rows="3" ng-required="true"></textarea>
                <span ng-if="!commentForm.$valid && commentValidate" class="text-danger">This field is required.</span>
                <br>
                <div>   
                    <div ng-if="comments_rollup_support" class="smaller-cpSwitch d-inline-block position-relative" style="top:8px;">
                        <label class="cp-switch">
                            <div class="d-inline-block"> {{'Roll up'|translate}} </div>
                            <input ng-click="commentsRollup($event)" ng-checked="comments_rollup" type="checkbox" name="roll_up" class="invisible" style="margin:0px -4px;" /> 
                            <span class="checkmark c-pointer position-relative" style="top: 4px;"></span>
                        </label>
                    </div>
                    <button type="submit" ng-disabled="savingComment" class="btn btn-success pull-right">{{'Submit'|translate}}</button>
                </div>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 comment-list">
            <div class="row " ng-repeat="comment in comments | orderBy:'createdtime':true |limitTo:comments.length">
                <br>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" ng-class="{'commentHighlighted' : (comment.id == selectedCommentId)}">
                    <hr class="hrHeader"><br>
                    <a name="comment-{{comment.id}}"></a>
                    <p class="usertitle commnet-owner">
                        <b class="uname" ng-if="comment.creator.label!=='' && !comment.customer.label"><strong>{{comment.creator.label}}&nbsp;</strong></b>
                        <b class="uname" ng-if="comment.creator.label!=='' && comment.customer.label"><strong>{{comment.customer.label}}&nbsp;</strong></b>
                        <small class="utime">{{comment.createdtime|amUtc|amLocal|amDateFormat:'YYYY-MM-DD HH:mm:ss'|dateTimeFormat}}</small>
                        <span ng-if="comment.related_to && id != comment.related_to.value" style="margin-left:16px;">
                            <a href="index.php?module={{comment.related_to.module}}&view=Detail&id={{comment.related_to.value}}&parentId={{id}}" target="_blank"> {{ comment.related_to.label }} </a>
                        </span>
                    </p>
                    <br>
                    <p class="comment-content" style="white-space: pre-line;" ng-bind-html="comment.commentcontent | unsafe"></p>
					<ul class="comment-docs">
						<li ng-repeat=" attachment in comment.attachments"><a><small ng-if="attachment.filename" ng-click="downloadCommentFile('ModComments',comment.id,attachment.attachmentid)">{{attachment.filename}}</small><i class="glyphicon glyphicon-download-alt comment-document" style="margin-left:5px;" ng-click="downloadCommentFile('ModComments',comment.id,attachment.attachmentid)"></i></a></li>
					</ul>
                </div>
            </div>
            <p ng-if="loadingData" class="text-muted alert alert-info">{{'Loading'|translate}}...</p>
            <a ng-if="!loadingData && !commentsLoaded && !noComments && showMoreComments" ng-click="loadCommentsPage(commentPageNo)">{{'more'|translate}}...</a>
            <p ng-if="!loadingData && !showMoreComments && commentPageNo > 1" class="text-muted">{{'No more comments'|translate}}</p>
            <p ng-if="!loadingData && !comments.length" class="text-muted alert alert-warning">{{'No comments'|translate}}</p>
        </div>
    </div>
{/literal}
