{*<!--
  /*
   *Copyright (C) www.vtiger.com. All rights reserved.
   * @license Proprietary
  */
-->*}

{literal}
    <script type="text/ng-template" id="filterModal.template">
        <form class="form form-vertical" name="filterForm">
            <div>
                <div class="modal-header">
                    <button type="button" class="close" ng-click="cancel()" title="Close">&times;</button>
                    <h4 class="modal-title" >{{'Filters'|translate}}</h4>
                </div>
                <div ng-if="Object.keys(filterFieldsInfo).length === 0">
                    <div class="modal-body">
                        {{ 'No filters configured'|translate }}
                    </div>
                </div>
                <div ng-if="Object.keys(filterFieldsInfo).length !== 0">
                    <div class="modal-body">
                        <div ng-repeat="(fieldName, fieldInfo) in filterFieldsInfo">
                            <label>{{fieldInfo.fieldLabel}}</label>
                            <ui-select multiple name="name" theme="bootstrap" ng-model="fieldInfo.selectedPicklistValues" portal-select>
                                <ui-select-match>{{$item.label}}</ui-select-match>
                                <ui-select-choices repeat="picklistValue in fieldInfo.picklistValues|propsFilter: {label: $select.search,value: $select.search} track by picklistValue.label">
                                    {{picklistValue.label}}
                                </ui-select-choices>
                            </ui-select>
                            <br>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success" ng-click="applyFilter()" translate="Apply"></button>
                    </div>
                </div>
            </div>
        </form>
    </script>
{/literal}