{*<!--
  /*
   *Copyright (C) www.vtiger.com. All rights reserved.
   * @license Proprietary
  */
-->*}

{literal}
    <div class="cp-table-container">
        <div ng-if="isTasksFilterEnabled && (tasksRecords.length || searchApplied)" class="d-inline-block full-width">
            <div class="filterbtnContainer col-lg-2 col-md-2 col-sm-2 col-xs-2 p-0">
                <button class="btn btn-primary" ng-click="openFilter('Calendar')">
                    {{'Filters'|translate}} <span ng-if="Calendar_appliedFiltersCount > 0"> ({{ Calendar_appliedFiltersCount }}) </span>
                </button>
            </div>
        </div>
        <br/>
        <div class="table-responsive" ng-show="!loadingTasks && tasksRecords.length">
            <table class="table table-hover table-condensed table-detailed dataTable no-footer">
                <thead>
                    <tr class="listViewHeaders">
                        <th ng-hide="header=='id'" ng-repeat="header in tasksHeaders" nowrap="" class="medium">
                            <a href="javascript:void(0);" class="listViewHeaderValues" data-nextsortorderval="ASC" data-columnname="{{header}}" translate="{{header}}">{{header}}&nbsp;&nbsp;</a>
                        </th>
                        <th class='listViewLastActionHeader'> </th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="listViewEntries" ng-repeat="record in tasksRecords">
                        <td ng-hide="header=='id'" ng-repeat="header in tasksHeaders" class="listViewEntryValue medium" nowrap="" style='cursor: pointer;' ng-click="ChangeLocation('Calendar', record.id)">
                            <ng-switch on="record[header].type">
                                <a ng-href="index.php?module=Calendar&view=Detail&id={{record.id}}"></a>
                                <span ng-if="::isRelatedRecordDateTimeField(header,relatedRecordsDateTimeFields) === false && isRelatedRecordDateField(header,relatedRecordsDateFields) === false" ng-bind-html="record[header].toString()|linky:'_blank'"></span>
                                <span ng-if="::isRelatedRecordDateTimeField(header,relatedRecordsDateTimeFields) === true">{{record[header]|amUtc|amLocal|amDateFormat:'YYYY-MM-DD HH:mm:ss'|dateTimeFormat}}</span>
								<span ng-if="::isRelatedRecordDateField(header,relatedRecordsDateFields) === true">{{record[header]|dateFormat}}</span>
                            </ng-switch>
                        </td>
                        <td class="listViewLastActionColumn">
                            <div class='actionsContainer'>
                                <span class="action openin_newtab" title="{{'Open in new tab'|translate}}" ng-click="ChangeLocation('Calendar',record, '_blank')">
                                    <i class="fa fa-external-link"> </i>
                                </span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <p ng-if="loadingData" class="text-muted alert alert-info">{{'loading'|translate}}...</p>
    <a ng-if="!loadingData && !tasksRecordsLoaded && !noTasksRecords && showMoreTasks" ng-click="loadTasksPage(tasksPageNo)">{{'more'|translate}}...</a>
    <p ng-if="!loadingData && tasksRecordsLoaded" class="text-muted alert alert-warning">{{'No Tasks'|translate}}</p>
    <p ng-if="!loadingData && !showMoreTasks && !tasksRecordsLoaded && noTasksRecords && tasksPageNo > 1" class="text-muted">{{'No more Tasks'|translate}}</p>
{/literal}
